#declare aspectratio=640/480;    //1600/1200;

global_settings{assumed_gamma 1 max_trace_level 180 charset utf8} 

//some unit conversions that seem useful:
#declare inches=1;
#declare feet=12;    
#declare yards=36;
#declare miles=12*5280;
#declare meters=1000/25.4;
#declare millimeters=1/25.4;
#declare mm=1/25.4;
#declare centimeters=1/2.54;
#declare cm=1/2.54; 
#declare microns=1/25400;
#declare kilometers=1000000/25.4;


//includes
#include "colors.inc"       
#include "metals.inc"
#include "glass.inc"
#include "textures.inc"  

//Highway scene for example signs 
#include "highway.inc"


   camera{right x*aspectratio location 0 look_at <-1,-.0,0> rotate 0*y translate<4*feet,-20,-5*feet>}

  
                          
    #include "roadsigns.inc"
         
         //Guide sign: Exit 109A, OK-9, Tecumseh    
         object{bgs(array[2]{"OK9.png","EAST"},array[2]{2,0},array[1]{"Tecumseh"},1,"109A",0,"2","MILES",0) rotate -90*y translate <-50,-10,-90>}
         
         //Guide sign: Exit 34, MD-36, Frostburg/Westernport
         object{bgs(array[1]{"MD36.png"},array[1]{2},array[2]{"Westernport","Frostburg"},1,"34",0,"2","MILES",0) rotate -90*y translate <-50,-10,-55>}
         
         //Guide sign: I-35, Okla City
         object{bgs(array[2]{"I35OK.png","NORTH"},array[2]{2,0},array[1]{"Okla City"},0,"109A",1,"$","MILES",0) rotate -90*y translate <-50,-10,-20>}   //"$" right arrow "4" left arrow 
         
         //Street sign: Lindsey St.
         //object{signblade("LINDSEY ST."," 500",.5,0,1," WEST",3,1,"Normanblue.png",1,pigment{rgb <1,0,0>},0) rotate -90*y translate <-50,-30,-90>}
         object{normanredsignblade("LINDSEY ST."," 500", " WEST") rotate -90*y translate <-50,-30,-90>}
         
         //Green street sign: Lindsey St.
         //object{signblade("Lindsey St."," 500",.5,0,1," West",3,1,"Norman.png",1,bgsgreen,0) rotate -90*y translate <-50,-40,-90>} 
         object{normangreensignblade("Lindsey St."," 500", " West") rotate -90*y translate <-50,-40,-90>} 
         
         //Generic green street sign: Brooks St.
         object{signblade("W Brooks"," St.",.5,0,0," West",3,0,"Norman.png",1,bgsgreen,0) rotate -90*y translate <-50,-50,-90>}      
         
         //75 mph Speed Limit
         object{speedlimitsign("75") rotate -90*y translate <-50,-50,-20>}
         
         //c Speed Limit
         object{speedlimitsign("c") rotate -90*y translate <-50,-55,-50>}